/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.pmod.impl.wcl;

import com.ibm.hwmca.fw.servlet.pmod.datamodel.PmListModel;
import com.ibm.hwmca.fw.util.Trace;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ListSelectionModelImpl
implements ListSelectionModel {
    public static final int NO_SELECT = -1;
    private boolean valueIsAdjusting;
    private List listeners;
    private PmListModel pmListModel;
    private int selectionMode = 2;
    private int anchorIndex;
    private int leadIndex;
    private static final String TRACE_MASKD = "XPMTSMID";
    private static final String TRACE_MASKF = "XPMTSMIF";
    private static final String TRACE_MASKT = "XPMTSMIT";

    public ListSelectionModelImpl(PmListModel pmListModel) {
        this.pmListModel = pmListModel;
        this.listeners = new ArrayList();
    }

    public int getMinSelectionIndex() {
        Trace.trace(TRACE_MASKT, "LSMI.getMinSelectionIndex()");
        if (this.selectionMode == -1) {
            return -1;
        }
        int[] sel = this.getSelectedRows();
        if (sel.length == 0) {
            return -1;
        }
        Trace.trace(TRACE_MASKT, "LSMI.getMinSelectionIndex() returning: " + sel[0]);
        return sel[0];
    }

    public void setSelectionInterval(int index0, int index1) {
        Trace.trace(TRACE_MASKT, "LSMI.setSelectionInterval(" + index0 + "," + index1 + ")");
        if (this.selectionMode != -1) {
            if (this.selectionMode == 0) {
                index1 = index0;
                this.clearAll();
            }
            int[] currentSel = this.getSelectedRows();
            int newSelIntervalSize = index0 - index1;
            if (newSelIntervalSize < 0) {
                newSelIntervalSize *= -1;
            }
            int[] newSel = new int[++newSelIntervalSize];
            int i = 0;
            while (i < newSelIntervalSize) {
                newSel[i] = index0 == index1 ? index0 : (index0 < index1 ? index0 + i : index1 + i);
                ++i;
            }
            if (!Arrays.equals(currentSel, newSel)) {
                this.anchorIndex = index0;
                this.leadIndex = index1;
                this.pmListModel.setSelected(newSel);
                ListSelectionEvent e = new ListSelectionEvent(this, index0, index1, this.valueIsAdjusting);
                Iterator iterator = ((List)((ArrayList)this.listeners).clone()).iterator();
                while (iterator.hasNext()) {
                    ListSelectionListener listener = (ListSelectionListener)iterator.next();
                    listener.valueChanged(e);
                }
            }
        }
    }

    public void removeSelectionInterval(int index0, int index1) {
        Trace.trace(TRACE_MASKT, "LSMI.removeSelectionInterval(" + index0 + "," + index1 + ")");
        if (this.selectionMode != -1) {
            if (this.selectionMode == 0) {
                index1 = index0;
            }
            int[] currentSel = this.getSelectedRows();
            int remSelIntervalSize = index0 - index1;
            if (remSelIntervalSize < 0) {
                remSelIntervalSize *= -1;
            }
            int[] selSubtraction = new int[++remSelIntervalSize];
            int i = 0;
            while (i < selSubtraction.length) {
                selSubtraction[i] = index0 == index1 ? index0 : (index0 > index1 ? index1 - 1 : index0 + i);
                ++i;
            }
            int uniqueEntries = currentSel.length;
            int i2 = 0;
            while (i2 < selSubtraction.length) {
                boolean found = false;
                int j = 0;
                while (j < currentSel.length) {
                    if (currentSel[j] == selSubtraction[i2]) {
                        found = true;
                        j = currentSel.length;
                    }
                    ++j;
                }
                if (found) {
                    --uniqueEntries;
                }
                ++i2;
            }
            int[] newSelection = new int[uniqueEntries];
            uniqueEntries = 0;
            int i3 = 0;
            while (i3 < currentSel.length) {
                boolean found = false;
                int j = 0;
                while (j < selSubtraction.length) {
                    if (currentSel[i3] == selSubtraction[j]) {
                        found = true;
                        j = selSubtraction.length;
                    }
                    ++j;
                }
                if (!found) {
                    newSelection[uniqueEntries++] = currentSel[i3];
                }
                ++i3;
            }
            Arrays.sort(newSelection);
            this.anchorIndex = index0;
            this.leadIndex = index1;
            if (newSelection.length != currentSel.length) {
                this.pmListModel.setSelected(newSelection);
                ListSelectionEvent e = new ListSelectionEvent(this, index0, index1, this.valueIsAdjusting);
                Iterator iterator = ((List)((ArrayList)this.listeners).clone()).iterator();
                while (iterator.hasNext()) {
                    ListSelectionListener listener = (ListSelectionListener)iterator.next();
                    listener.valueChanged(e);
                }
            }
            Trace.trace(TRACE_MASKF, "new selection values:");
            int i4 = 0;
            while (i4 < newSelection.length) {
                Trace.trace(TRACE_MASKF, "newSelection[" + i4 + "]: " + newSelection[i4]);
                ++i4;
            }
        }
    }

    public void insertIndexInterval(int index, int length, boolean before) {
        Trace.trace(TRACE_MASKT, "LSMI.insertIndexInterval(" + index + "," + length + "," + before + ")");
        Trace.trace(TRACE_MASKF, "TSMI -- Not implemented!! --");
    }

    public void addSelectionInterval(int index0, int index1) {
        Trace.trace(TRACE_MASKT, "LSMI.addSelectionInterval(" + index0 + "," + index1 + ")");
        if (this.selectionMode != -1) {
            if (this.selectionMode == 0) {
                index1 = index0;
                this.clearAll();
            }
            int[] currentSel = this.getSelectedRows();
            int newSelIntervalSize = index0 - index1;
            if (newSelIntervalSize < 0) {
                newSelIntervalSize *= -1;
            }
            int[] newSelAddition = new int[++newSelIntervalSize];
            int i = 0;
            while (i < newSelAddition.length) {
                newSelAddition[i] = index0 == index1 ? index0 : (index0 > index1 ? index1 - 1 : index0 + i);
                ++i;
            }
            Trace.trace(TRACE_MASKF, "currentSel.length: " + currentSel.length);
            int i2 = 0;
            while (i2 < currentSel.length) {
                Trace.trace(TRACE_MASKF, "currentSel[" + i2 + "]: " + currentSel[i2]);
                ++i2;
            }
            Trace.trace(TRACE_MASKF, "newSelAddition.length: " + newSelAddition.length);
            int i3 = 0;
            while (i3 < newSelAddition.length) {
                Trace.trace(TRACE_MASKF, "newSelAddition[" + i3 + "]: " + newSelAddition[i3]);
                ++i3;
            }
            int uniqueEntries = currentSel.length;
            int i4 = 0;
            while (i4 < newSelAddition.length) {
                boolean found = false;
                int j = 0;
                while (j < currentSel.length) {
                    if (currentSel[j] == newSelAddition[i4]) {
                        found = true;
                        j = currentSel.length;
                    }
                    ++j;
                }
                if (!found) {
                    ++uniqueEntries;
                }
                ++i4;
            }
            Trace.trace(TRACE_MASKF, "unique entries: " + uniqueEntries);
            int[] newSelection = new int[uniqueEntries];
            System.arraycopy(currentSel, 0, newSelection, 0, currentSel.length);
            uniqueEntries = currentSel.length;
            int i5 = 0;
            while (i5 < newSelAddition.length) {
                boolean found = false;
                int j = 0;
                while (j < currentSel.length) {
                    if (currentSel[j] == newSelAddition[i5]) {
                        found = true;
                        j = currentSel.length;
                    }
                    ++j;
                }
                if (!found) {
                    newSelection[uniqueEntries++] = newSelAddition[i5];
                }
                ++i5;
            }
            Arrays.sort(newSelection);
            this.anchorIndex = index0;
            this.leadIndex = index1;
            if (newSelection.length != currentSel.length) {
                this.pmListModel.setSelected(newSelection);
                ListSelectionEvent e = new ListSelectionEvent(this, index0, index1, this.valueIsAdjusting);
                Iterator iterator = ((List)((ArrayList)this.listeners).clone()).iterator();
                while (iterator.hasNext()) {
                    ListSelectionListener listener = (ListSelectionListener)iterator.next();
                    listener.valueChanged(e);
                }
            }
            Trace.trace(TRACE_MASKF, "new selection values:");
            int i6 = 0;
            while (i6 < newSelection.length) {
                Trace.trace(TRACE_MASKF, "newSelection[" + i6 + "]: " + newSelection[i6]);
                ++i6;
            }
        }
    }

    public boolean isSelectedIndex(int index) {
        Trace.trace(TRACE_MASKT, "LSMI.isSelectedIndex(" + index + ")");
        int[] sel = this.getSelectedRows();
        int i = 0;
        while (i < sel.length) {
            if (sel[i] == index) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setAnchorSelectionIndex(int index) {
        Trace.trace(TRACE_MASKT, "LSMI.setAnchorSelectionIndex(" + index + ")");
        this.anchorIndex = index;
    }

    public int getMaxSelectionIndex() {
        Trace.trace(TRACE_MASKT, "LSMI.getMaxSelectionIndex()");
        if (this.selectionMode == -1) {
            return -1;
        }
        int[] sel = this.getSelectedRows();
        if (sel.length == 0) {
            return -1;
        }
        return sel[sel.length - 1];
    }

    public void setLeadSelectionIndex(int index) {
        Trace.trace(TRACE_MASKT, "LSMI.setLeadSelectionIndex(" + index + ")");
        this.leadIndex = index;
    }

    public int getAnchorSelectionIndex() {
        Trace.trace(TRACE_MASKT, "LSMI.getAnchorSelectionIndex()");
        return this.anchorIndex;
    }

    public boolean isSelectionEmpty() {
        Trace.trace(TRACE_MASKT, "LSMI.isSelectionEmpty()");
        return this.getSelectedRows().length == 0;
    }

    public int getLeadSelectionIndex() {
        Trace.trace(TRACE_MASKT, "LSMI.getLeadSelectionIndex()");
        return this.leadIndex;
    }

    public void removeIndexInterval(int index0, int index1) {
        Trace.trace(TRACE_MASKT, "LSMI.removeIndexInterval(" + index0 + "," + index1 + ")");
        Trace.trace(TRACE_MASKF, "TSMI -- Not implemented!! --");
        this.anchorIndex = index0;
        this.leadIndex = index1;
    }

    public void clearSelection() {
        Trace.trace(TRACE_MASKT, "LSMI.clearSelection()");
        this.pmListModel.setSelected(new int[0]);
    }

    public boolean getValueIsAdjusting() {
        Trace.trace(TRACE_MASKT, "LSMI.getValueIsAdjusting()");
        return this.valueIsAdjusting;
    }

    public int getSelectionMode() {
        Trace.trace(TRACE_MASKT, "LSMI.getSelectionMode()");
        return this.selectionMode;
    }

    public void setValueIsAdjusting(boolean valueIsAdjusting) {
        Trace.trace(TRACE_MASKT, "LSMI.setValueIsAdjusting(" + valueIsAdjusting + ")");
        this.valueIsAdjusting = valueIsAdjusting;
    }

    public void removeListSelectionListener(ListSelectionListener listener) {
        Trace.trace(TRACE_MASKT, "LSMI.removeListSelectionListener(" + listener + ")");
        this.listeners.remove(listener);
    }

    public void setSelectionMode(int selectionMode) {
        Trace.trace(TRACE_MASKT, "LSMI.setSelectionMode(" + selectionMode + ")");
        switch (selectionMode) {
            case -1: 
            case 0: 
            case 1: 
            case 2: {
                this.selectionMode = selectionMode;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid selectionMode");
            }
        }
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        Trace.trace(TRACE_MASKT, "LSMI.addListSelectionListener(" + listener + ")");
        this.listeners.add(listener);
    }

    public int[] getSelectedRows() {
        Trace.trace(TRACE_MASKT, "LSMI.getSelectedRows()");
        if (this.selectionMode == -1) {
            return new int[0];
        }
        int[] sel = this.pmListModel.getSelected();
        if (sel == null) {
            return new int[0];
        }
        return sel;
    }

    public int getSelectedRowCount() {
        Trace.trace(TRACE_MASKT, "LSMI.getSelectedRowCount()");
        if (this.selectionMode == -1) {
            return 0;
        }
        return this.getSelectedRows().length;
    }

    public int[] getSelectedModelRows() {
        Trace.trace(TRACE_MASKT, "LSMI.getSelectedModelRows()");
        if (this.selectionMode == -1) {
            return new int[0];
        }
        return this.getSelectedRows();
    }

    public int getSelectedModelRowCount() {
        Trace.trace(TRACE_MASKT, "LSMI.getSelectedModelRowCount()");
        if (this.selectionMode == -1) {
            return 0;
        }
        return this.getSelectedRowCount();
    }

    public boolean isSelectedModelIndex(int index) {
        Trace.trace(TRACE_MASKT, "LSMI.isSelectedModelIndex(" + index + ")");
        if (this.selectionMode == -1) {
            return false;
        }
        return this.isSelectedIndex(index);
    }

    public void selectAll() {
        Trace.trace(TRACE_MASKT, "LSMI.selectAll()");
        if (this.selectionMode != -1) {
            if (this.selectionMode == 0) {
                if (this.pmListModel.getSize() > 0) {
                    this.pmListModel.setSelected(new int[]{0});
                }
            } else {
                int[] newSel = new int[this.pmListModel.getSize()];
                int i = 0;
                while (i < newSel.length) {
                    newSel[i] = i;
                    ++i;
                }
                this.pmListModel.setSelected(newSel);
            }
        }
    }

    public void clearAll() {
        Trace.trace(TRACE_MASKT, "LSMI.clearAll()");
        if (this.selectionMode != -1) {
            this.pmListModel.setSelected(new int[0]);
        }
    }
}

